<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Pages;
use Inertia\Inertia;
use Spatie\QueryBuilder\AllowedFilter;
use Spatie\QueryBuilder\QueryBuilder;
class NewsController extends Controller
{
    public function show($slug)
    {
        $news = Pages::where('categories', 2)->where('slug', $slug)
            ->leftJoin('users','t_pages.created_by','=','users.id')
            ->select('t_pages.*','users.name')
            ->firstOrFail();
        $new_news = Pages::where('categories', 2) ->orderBy('id','DESC')->take(5)->get();
        
        return Inertia::render('News_Detail', [
            'news' => $news,
            'new_news' => $new_news
        ]);
    }
    public function searchNews()
    {
        $news = QueryBuilder::for(Pages::class)
            ->join('users','t_pages.created_by','=','users.id')
            ->select('t_pages.*','users.name')
            ->allowedFilters('title')
            ->where('categories','=','2')
            ->orderBy('id','DESC')
            ->paginate(10)
            ->appends(request()->query());
        $new_news = Pages::where('categories', 2) ->orderBy('id','DESC')->take(5)->get();
        return Inertia::render('News', [
            'news' => $news,
            'new_news' => $new_news
        ]);
    }
    public function berita()
    {
        $news = QueryBuilder::for(Pages::class)
            ->join('users','t_pages.created_by','=','users.id')
            ->select('t_pages.*','users.name')
            ->orderBy('id','DESC')
            ->where('categories','=','2')
            ->paginate(10)
            ->appends(request()->query());
        $new_news = Pages::where('categories', 2)
            ->join('users','t_pages.created_by','=','users.id')
            ->select('t_pages.*','users.name')
            ->orderBy('id','DESC')
            ->take(5)
            ->get();
        return Inertia::render('News', [
            'news' => $news,
            'new_news' => $new_news
        ]);
    }
}
