<?php

namespace App\Http\Controllers;

use App\Models\Courts;
use App\Models\LegalProductsCategories;
use App\Models\Menu;
use Elasticsearch\ClientBuilder;
use Illuminate\Http\Request;
use Inertia\Inertia;
use stdClass;
use App\Models\Pages;
use App\Models\LegalProducts;
use App\Models\User;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Route ;
use Spatie\QueryBuilder\QueryBuilder;
use Spatie\Tags\Tag;
class WelcomeController extends Controller
{
    public $court;

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function index_satker()
    {
        $kode_satker = config('kode_satker.kode_satker');
        return Inertia::render('Welcome',[
            'kode_satker' => $kode_satker
        ]);
    }
    
    public function daftar_berita()
    {
        return Inertia::render('SatkerDaftarBerita');
    }

    public function berita_tunggal($slug)
    {
        $env_slug = $slug;
        return Inertia::render('SatkerBeritaTunggal',[
            'slug' => $env_slug
        ]);
    }

    public function detil_undang($slug)
    {

        $env_slug = $slug;
        return Inertia::render('SatkerDetilUndang',[
            'slug' => $env_slug
        ]);
    }


    public function hasil_pencarian(Request $request)
    {
        $client = new Client();

        $response = $client->request('GET', env('API_URL') . '/api/search-legal-product/',
            [
                'query' => [
                    "search" => $request->search,
                    "productCategory" => $request->productCategory, 
                    "productType" => $request->productType,
                    "year" => $request->year,
                    "page" => $request->page,
                    "order" => $request->order,
                    "orderBy" => $request->orderBy,
                ]
            ]
        );

        $responseBody = json_decode($response->getBody());

        $kode_satker = config('kode_satker.kode_satker');

        return Inertia::render('HasilPencarianElastic',[
            'kode_satker' => $kode_satker,
            'response' => $responseBody
        ]);
    }

    public function all()
    {
        $client = new Client();

        $response = $client->request('GET', env('API_URL') . '/api/category-legal-product-all/' . env('KODE_SATKER'));

        $responseBody = json_decode($response->getBody());

        $kode_satker = config('kode_satker.kode_satker');

        return Inertia::render('SatkerHasilPencarian',[
            'kode_satker' => $kode_satker,
            'response' => $responseBody
        ]);
    }

    public function category($slug)
    {
        $client = new Client();

        $response = $client->request('GET', env('API_URL') . '/api/category-legal-product/' . $slug . '/' . env('KODE_SATKER'));
        
        $responseBody = json_decode($response->getBody());

        $kode_satker = config('kode_satker.kode_satker');

        return Inertia::render('SatkerHasilPencarian',[
            'kode_satker' => $kode_satker,
            'category' => $slug,
            'response' => $responseBody
        ]);
    }
    public function categoryType($category,  $slug)
    {
        $client = new Client();

        $response = $client->request('GET', env('API_URL') . '/api/category-legal-product/'. $category .'/'. $slug .'/'. env('KODE_SATKER'));
        
        $responseBody = json_decode($response->getBody());

        $kode_satker = config('kode_satker.kode_satker');

        return Inertia::render('SatkerHasilPencarian',[
            'kode_satker' => $kode_satker,
            'category' => $category,
            'slug' => $slug,
            'response' => $responseBody
        ]);
    }

    public function searchNews()
    {
        return Inertia::render('SatkerDaftarBerita');
    }

    public function addDownloadData()
    {   
        return back();  
    }

    public static function menu()
    {

        $menus = Menu::where('parent_menu', null)
            // ->when(Route::current()->parameter('subdomain'), function($query){
            //     $user = User::where('id', auth()->user()->id)->firstOrFail();
            //     return $query->where('place_set', $user->kd_satker);
            // })
            ->with('children')->orderBy('order', 'ASC')->get();

        $productCategory = LegalProductsCategories::with('children')->get();

        $menuArray = [];

        foreach ($menus as $key => $value) {
            if($value->type == '1') {
                $menuArray[$key]['id'] = $value->id;
                $menuArray[$key]['name'] = $value->name;
                $menuArray[$key]['link'] = $value->link;
                $menuArray[$key]['children'] = $productCategory->toArray();

            } else {
                $menuArray[$key]['id'] = $value->id;
                $menuArray[$key]['name'] = $value->name;
                $menuArray[$key]['link'] = $value->link;
                $menuArray[$key]['children'] = $value->children;
            }
        }
        return $menuArray;
    }

    public static function kode_satker()
    {
        $kode_satker = config('kode_satker.kode_satker');

        return $kode_satker;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function filterResult(Request $request)
    {
        $client = new Client();

        $response = $client->request('GET', env('API_URL') . '/api/category-legal-product-all/' . env('KODE_SATKER'),
            [
                'query' => [
                    "productCategory" => $request->productCategory, 
                    "productType" => $request->productType,
                    "year" => $request->year,
                    "page" => $request->page,
                    "order" => $request->order,
                    "orderBy" => $request->orderBy,
                ]
            ]
        );

        $responseBody = json_decode($response->getBody());

        $kode_satker = config('kode_satker.kode_satker');
        return Inertia::render('SatkerHasilPencarian',[
            'kode_satker' => $kode_satker,
            'page' => $request->page,
            'response' => $responseBody
        ]);
    }
}
