<?php

namespace App\Http\Middleware;

use App\Http\Controllers\RolePermissionController;
use App\Http\Controllers\WelcomeController;
use Illuminate\Http\Request;
use Inertia\Middleware;

class HandleInertiaRequests extends Middleware
{
    /**
     * The root template that is loaded on the first page visit.
     *
     * @var string
     */
    protected $rootView = 'app';
    // public function rootView(Request $request)
    // {
        
    //     if ($request->is(['admin', 'admin/*'])) {
    //         return 'app';
    //     } else {
    //         return 'frontend';
    //     }

    // }

    /**
     * Determine the current asset version.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return string|null
     */
    public function version(Request $request)
    {
        return parent::version($request);
    }

    /**
     * Define the props that are shared by default.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function share(Request $request)
    {
        return array_merge(parent::share($request), [
            'api_url' => env('API_URL'),
            'jdih_url' => env('JDIH_URL'),
            'menu' => WelcomeController::kode_satker()
        ]);
    }
}
