<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class LegalProductsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'required|max:255',
            'description' => 'required',
            'no' => 'required|max:255',
            'year' => 'required|max:4',
            'm_legal_products_types_id' => 'required',
            'm_legal_products_categories_id' => 'required',
            'date_set' => 'required|date',
            'invited_date' => 'required|date',
            'no_ln' => 'required|max:255',
            'no_tln' => 'required|max:255',
            'status' => 'required',
            'file' => 'nullable|mimes:pdf|max:5048',
            't_court_id' => 'required',
            'publish' => 'required',
        ];
    }

    
}
