<?php

namespace App\Models;

use App\Blameable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;
use Illuminate\Database\Eloquent\SoftDeletes;

class Courts extends Model
{
    use HasFactory, Blameable, SoftDeletes, HasSlug;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'public.t_satker';
    protected $primaryKey = 'id';
    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = [];

    /**
     * Get the options for generating the slug.
     */
    public function getSlugOptions() : SlugOptions
    {
        return SlugOptions::create()
            ->generateSlugsFrom('name')
            ->saveSlugsTo('slug');
    }

    public function courtCategory()
    {
        return $this->belongsTo(CourtCategories::class,'m_court_categories_id','id');
    }

    public function justiceCategory()
    {
        return $this->belongsTo(JusticeCategories::class,'m_justice_categories_id','id');
    }

    public function courtClass()
    {
        return $this->belongsTo(CourtClass::class,'m_court_class_id','id');
    }

    public function provinces()
    {
        return $this->belongsTo(Provinces::class,'m_provinces_id','id');
    }

    public function regencies()
    {
        return $this->belongsTo(Regencies::class,'m_regencies_id','id');
    }
}
