<?php

namespace App\Models;

use App\Blameable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;
use Spatie\Tags\HasTags;

class LegalProducts extends Model
{
    use HasFactory, HasSlug, Blameable, SoftDeletes, HasTags;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 't_legal_products';

    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = [];

    /**
     * Get the options for generating the slug.
     */
    public function getSlugOptions() : SlugOptions
    {
        return SlugOptions::create()
            ->generateSlugsFrom('name')
            ->saveSlugsTo('slug');
    }

    protected $parentColumn = 'law_product_parent';

    public function parent()
    {
        return $this->belongsTo(self::class,$this->parentColumn);
    }

    public function children()
    {
        return $this->hasMany(self::class, $this->parentColumn)->with('children');
    }

    public function allChildren()
    {
        return $this->children()->with('allChildren');
    }

    protected $appends = ['label'];

    public function getLabelAttribute()
    {

        return $this->attributes['name'] ?? '';

    }

    public function getRelatedRegulatoryTagsAttribute()
    {

        return json_decode($this->attributes['related_regulatory_tags'], true);

    }

    public function court()
    {
        return $this->belongsTo(Courts::class,'t_court_id','id');
    }

    public function legalProductCategory()
    {
        return $this->belongsTo(LegalProductsCategories::class,'m_legal_products_categories_id','id');
    }

    public function legalProductType()
    {
        return $this->belongsTo(LegalProductsTypes::class,'m_legal_products_types_id','id');
    }
}
