<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;
use Illuminate\Database\Eloquent\SoftDeletes; 
class LegalProductsCategories extends Model
{
    use HasFactory, HasSlug;
    use SoftDeletes;
    protected $table = 'm_legal_products_categories';

    protected $fillable = [
        'name',
        'm_justice_categories_id',
    ];

    /**
     * Get the options for generating the slug.
     */
    public function getSlugOptions() : SlugOptions
    {
        return SlugOptions::create()
            ->generateSlugsFrom('name')
            ->saveSlugsTo('slug');
    }

    // protected $parentColumn = 'parent_menu';

    // public function parent()
    // {
    //     return $this->belongsTo(LegalProductsTypes::class,'m_legal_products_category_id', 'id');
    // }

    public function children()
    {
        return $this->hasMany(LegalProductsTypes::class, 'm_legal_products_categories_id', 'id');
    }
}
