<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Menu extends Model
{
    use HasFactory;

    protected $table = 'menu';

    protected $guarder = [];

    protected $parentColumn = 'parent_menu';

    public function parent()
    {
        return $this->belongsTo(self::class,$this->parentColumn);
    }

    public function children()
    {
        return $this->hasMany(self::class, $this->parentColumn)->with('children');
    }

    public function allChildren()
    {
        return $this->children()->with('allChildren');
    }
}