<?php

namespace App\Models;

use App\Blameable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;

class NewsAdmin extends Model
{
    use HasFactory, HasSlug, Blameable, SoftDeletes;

    protected $table = 't_pages';
    protected $guarded = [];

    public function getSlugOptions() : SlugOptions
    {
        return SlugOptions::create()
            ->generateSlugsFrom('title')
            ->saveSlugsTo('slug');
    }

    protected $appends = ['label'];

    public function getLabelAttribute(){
        return $this->attributes['title'];
    }

    public function court()
    {
        return $this->belongsTo(Courts::class,'t_court_id','id');
    }
}
