<?php

namespace App\Observers;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

class BlameableObserver
{
    public function creating(Model $model)
    {
        $model->created_by = Auth::user()->id;
        $model->updated_by = Auth::user()->id;
        $model->deleted_by = -1;
    }

    public function updating(Model $model)
    {
        if (Auth::user() == null) {
            // $model->updated_by = 0;
        }
        elseif (Auth::user() != null){
            $model->updated_by = Auth::user()->id;
        }
    }

    public function deleting(Model $model)
    {
        $model->deleted_by = Auth::user()->id;
    }
}