<?php

namespace App\Policies;

use App\Models\Courts;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class CourtsPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function viewAny(User $user)
    {
        if($user->can('View Pengadilan'))
            return true;
    }

    /**
     * Determine whether the user can view the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Courts  $courts
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function view(User $user, Courts $courts)
    {
        //
    }

    /**
     * Determine whether the user can create models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function create(User $user)
    {
        if($user->can('Create Pengadilan'))
            return true;
    }

    /**
     * Determine whether the user can update the model.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function update(User $user)
    {
        if($user->can('Update Pengadilan'))
            return true;
    }

    /**
     * Determine whether the user can delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Courts  $courts
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function delete(User $user, Courts $courts)
    {
        if($user->can('Delete Pengadilan'))
            return true;
    }

    /**
     * Determine whether the user can restore the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Courts  $courts
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function restore(User $user, Courts $courts)
    {
        //
    }

    /**
     * Determine whether the user can permanently delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Courts  $courts
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function forceDelete(User $user, Courts $courts)
    {
        //
    }
}
