<?php

namespace App\Policies;

use App\Models\JusticeCategories;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class JusticeCategoriesPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function viewAny(User $user)
    {
        if($user->can('View Kategori Peradilan'))
            return true;
    }

    /**
     * Determine whether the user can view the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\JusticeCategories  $justiceCategories
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function view(User $user, JusticeCategories $justiceCategories)
    {
        //
    }

    /**
     * Determine whether the user can create models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function create(User $user)
    {
        if($user->can('Create Kategori Peradilan'))
            return true;
    }

    /**
     * Determine whether the user can update the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\JusticeCategories  $justiceCategories
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function update(User $user)
    {
        if($user->can('Update Kategori Peradilan'))
            return true;
    }

    /**
     * Determine whether the user can delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\JusticeCategories  $justiceCategories
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function delete(User $user)
    {
        if($user->can('Delete Kategori Peradilan'))
            return true;
    }

    /**
     * Determine whether the user can restore the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\JusticeCategories  $justiceCategories
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function restore(User $user, JusticeCategories $justiceCategories)
    {
        //
    }

    /**
     * Determine whether the user can permanently delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\JusticeCategories  $justiceCategories
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function forceDelete(User $user, JusticeCategories $justiceCategories)
    {
        //
    }
}
