<?php

namespace App\Policies;

use App\Models\LegalProductCategories;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class LegalProductsCategoriesPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function viewAny(User $user)
    {
        if($user->can('View Kategori Dokumen Hukum'))
            return true;
    }

    /**
     * Determine whether the user can view the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\LegalProductCategories  $legalProductCategories
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function view(User $user, LegalProductCategories $legalProductCategories)
    {
        //
    }

    /**
     * Determine whether the user can create models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function create(User $user)
    {
        if($user->can('Create Kategori Dokumen Hukum'))
            return true;
    }

    /**
     * Determine whether the user can update the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\LegalProductCategories  $legalProductCategories
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function update(User $user)
    {
        if($user->can('Update Kategori Dokumen Hukum'))
            return true;
    }

    /**
     * Determine whether the user can delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\LegalProductCategories  $legalProductCategories
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function delete(User $user)
    {
        if($user->can('Delete Kategori Dokumen Hukum'))
            return true;
    }

    /**
     * Determine whether the user can restore the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\LegalProductCategories  $legalProductCategories
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function restore(User $user, LegalProductCategories $legalProductCategories)
    {
        //
    }

    /**
     * Determine whether the user can permanently delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\LegalProductCategories  $legalProductCategories
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function forceDelete(User $user, LegalProductCategories $legalProductCategories)
    {
        //
    }
}
