<?php

namespace App\Policies;

use App\Models\LegalProducts;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class LegalProductsPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function viewAny(User $user)
    {
        if($user->can('View Dokumen Hukum'))
            return true;
    }

    /**
     * Determine whether the user can view the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\LegalProducts  $legalProducts
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function view(User $user)
    {
        if($user->can('View Dokumen Hukum'))
            return true;
    }

    /**
     * Determine whether the user can create models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function create(User $user)
    {
        if($user->can('Create Dokumen Hukum'))
            return true;
    }

    /**
     * Determine whether the user can update the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\LegalProducts  $legalProducts
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function update(User $user)
    {
        if($user->can('Update Dokumen Hukum'))
            return true;
    }

    /**
     * Determine whether the user can delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\LegalProducts  $legalProducts
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function delete(User $user)
    {
        if($user->can('Delete Dokumen Hukum'))
            return true;
    }

    /**
     * Determine whether the user can restore the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\LegalProducts  $legalProducts
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function restore(User $user, LegalProducts $legalProducts)
    {
        //
    }

    /**
     * Determine whether the user can permanently delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\LegalProducts  $legalProducts
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function forceDelete(User $user, LegalProducts $legalProducts)
    {
        //
    }
}
