<?php

namespace App\Policies;

use App\Models\LegalProductTypes;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class LegalProductsTypesPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function viewAny(User $user)
    {
        if($user->can('View Jenis Dokumen Hukum'))
            return true;
    }

    /**
     * Determine whether the user can view the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\LegalProductTypes  $legalProductTypes
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function view(User $user, LegalProductTypes $legalProductTypes)
    {
        //
    }

    /**
     * Determine whether the user can create models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function create(User $user)
    {
        if($user->can('Create Jenis Dokumen Hukum'))
            return true;
    }

    /**
     * Determine whether the user can update the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\LegalProductTypes  $legalProductTypes
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function update(User $user)
    {
        if($user->can('Update Jenis Dokumen Hukum'))
            return true;
    }

    /**
     * Determine whether the user can delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\LegalProductTypes  $legalProductTypes
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function delete(User $user)
    {
        if($user->can('Delete Jenis Dokumen Hukum'))
            return true;
    }

    /**
     * Determine whether the user can restore the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\LegalProductTypes  $legalProductTypes
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function restore(User $user, LegalProductTypes $legalProductTypes)
    {
        //
    }

    /**
     * Determine whether the user can permanently delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\LegalProductTypes  $legalProductTypes
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function forceDelete(User $user, LegalProductTypes $legalProductTypes)
    {
        //
    }
}
