<?php

namespace App\Policies;

use App\Models\Regencies;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class RegenciesPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function viewAny(User $user)
    {
        if($user->can('View Kabupaten'))
            return true;
    }

    /**
     * Determine whether the user can view the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Regencies  $regencies
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function view(User $user, Regencies $regencies)
    {
        //
    }

    /**
     * Determine whether the user can create models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function create(User $user)
    {
        if($user->can('Create Kabupaten'))
            return true;
    }

    /**
     * Determine whether the user can update the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Regencies  $regencies
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function update(User $user)
    {
        if($user->can('Update Kabupaten'))
            return true;
    }

    /**
     * Determine whether the user can delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Regencies  $regencies
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function delete(User $user)
    {
        if($user->can('Delete Kabupaten'))
            return true;
    }

    /**
     * Determine whether the user can restore the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Regencies  $regencies
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function restore(User $user, Regencies $regencies)
    {
        //
    }

    /**
     * Determine whether the user can permanently delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Regencies  $regencies
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function forceDelete(User $user, Regencies $regencies)
    {
        //
    }
}
