<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class RolesAndPermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Reset cached roles and permissions
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        // create permissions
        Permission::create(['name' => 'Dashboard', 'label' => 'Dashboard']);
        
        Permission::create(['name' => 'Manajemen Konten', 'label' => 'Manajemen Konten']);
        Permission::create(['name' => 'View Profil', 'label' => 'Manajemen Konten > Profil']);
        Permission::create(['name' => 'Create Profil', 'label' => 'Manajemen Konten > Profil']);
        Permission::create(['name' => 'Update Profil', 'label' => 'Manajemen Konten > Profil']);
        Permission::create(['name' => 'Delete Profil', 'label' => 'Manajemen Konten > Profil']);
        Permission::create(['name' => 'View Berita', 'label' => 'Manajemen Konten > Berita']);
        Permission::create(['name' => 'Create Berita', 'label' => 'Manajemen Konten > Berita']);
        Permission::create(['name' => 'Update Berita', 'label' => 'Manajemen Konten > Berita']);
        Permission::create(['name' => 'Delete Berita', 'label' => 'Manajemen Konten > Berita']);
        Permission::create(['name' => 'View Pengadilan', 'label' => 'Manajemen Konten > Pengadilan']);
        Permission::create(['name' => 'Create Pengadilan', 'label' => 'Manajemen Konten > Pengadilan']);
        Permission::create(['name' => 'Update Pengadilan', 'label' => 'Manajemen Konten > Pengadilan']);
        Permission::create(['name' => 'Delete Pengadilan', 'label' => 'Manajemen Konten > Pengadilan']);
        Permission::create(['name' => 'View Dokumen Hukum', 'label' => 'Manajemen Konten > Dokumen Hukum']);
        Permission::create(['name' => 'Create Dokumen Hukum', 'label' => 'Manajemen Konten > Dokumen Hukum']);
        Permission::create(['name' => 'Update Dokumen Hukum', 'label' => 'Manajemen Konten > Dokumen Hukum']);
        Permission::create(['name' => 'Delete Dokumen Hukum', 'label' => 'Manajemen Konten > Dokumen Hukum']);
        
        Permission::create(['name' => 'Manajemen User', 'label' => 'Manajemen User']);
        Permission::create(['name' => 'View Pendaftaran Admin', 'label' => 'Manajemen User > Pendaftaran Admin']);
        Permission::create(['name' => 'Create Pendaftaran Admin', 'label' => 'Manajemen User > Pendaftaran Admin']);
        Permission::create(['name' => 'Update Pendaftaran Admin', 'label' => 'Manajemen User > Pendaftaran Admin']);
        Permission::create(['name' => 'Delete Pendaftaran Admin', 'label' => 'Manajemen User > Pendaftaran Admin']);
        Permission::create(['name' => 'View User', 'label' => 'Manajemen User > User']);
        Permission::create(['name' => 'Create User', 'label' => 'Manajemen User > User']);
        Permission::create(['name' => 'Update User', 'label' => 'Manajemen User > User']);
        Permission::create(['name' => 'Delete User', 'label' => 'Manajemen User > User']);
        Permission::create(['name' => 'View Role', 'label' => 'Manajemen User > Role']);
        Permission::create(['name' => 'Create Role', 'label' => 'Manajemen User > Role']);
        Permission::create(['name' => 'Update Role', 'label' => 'Manajemen User > Role']);
        Permission::create(['name' => 'Delete Role', 'label' => 'Manajemen User > Role']);

        Permission::create(['name' => 'Manajemen Master', 'label' => 'Manajemen Master']);
        Permission::create(['name' => 'View Propinsi', 'label' => 'Manajemen Master > Propinsi']);
        Permission::create(['name' => 'Create Propinsi', 'label' => 'Manajemen Master > Propinsi']);
        Permission::create(['name' => 'Update Propinsi', 'label' => 'Manajemen Master > Propinsi']);
        Permission::create(['name' => 'Delete Propinsi', 'label' => 'Manajemen Master > Propinsi']);
        Permission::create(['name' => 'View Kabupaten', 'label' => 'Manajemen Master > Kabupaten']);
        Permission::create(['name' => 'Create Kabupaten', 'label' => 'Manajemen Master > Kabupaten']);
        Permission::create(['name' => 'Update Kabupaten', 'label' => 'Manajemen Master > Kabupaten']);
        Permission::create(['name' => 'Delete Kabupaten', 'label' => 'Manajemen Master > Kabupaten']);
        Permission::create(['name' => 'View Kategori Pengadilan', 'label' => 'Manajemen Master > Kategori Pengadilan']);
        Permission::create(['name' => 'Create Kategori Pengadilan', 'label' => 'Manajemen Master > Kategori Pengadilan']);
        Permission::create(['name' => 'Update Kategori Pengadilan', 'label' => 'Manajemen Master > Kategori Pengadilan']);
        Permission::create(['name' => 'Delete Kategori Pengadilan', 'label' => 'Manajemen Master > Kategori Pengadilan']);
        Permission::create(['name' => 'View Kategori Dokumen Hukum', 'label' => 'Manajemen Master > Kategori Dokumen Hukum']);
        Permission::create(['name' => 'Create Kategori Dokumen Hukum', 'label' => 'Manajemen Master > Kategori Dokumen Hukum']);
        Permission::create(['name' => 'Update Kategori Dokumen Hukum', 'label' => 'Manajemen Master > Kategori Dokumen Hukum']);
        Permission::create(['name' => 'Delete Kategori Dokumen Hukum', 'label' => 'Manajemen Master > Kategori Dokumen Hukum']);
        Permission::create(['name' => 'View Jenis Dokumen Hukum', 'label' => 'Manajemen Master > Jenis Dokumen Hukum']);
        Permission::create(['name' => 'Create Jenis Dokumen Hukum', 'label' => 'Manajemen Master > Jenis Dokumen Hukum']);
        Permission::create(['name' => 'Update Jenis Dokumen Hukum', 'label' => 'Manajemen Master > Jenis Dokumen Hukum']);
        Permission::create(['name' => 'Delete Jenis Dokumen Hukum', 'label' => 'Manajemen Master > Jenis Dokumen Hukum']);
        

        // create roles and assign created permissions

        $role = Role::create(['name' => 'Staff'])
            ->givePermissionTo([
                'Dashboard',
                'View Berita',
                'Create Berita',
                'Update Berita',
                'Delete Berita',
            ]);

        $role = Role::create(['name' => 'Superadmin']);
        $role->givePermissionTo(Permission::all());
    }
}
