"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = formatRelative;
var formatRelativeLocale = {
  lastWeek: function (date) {
    var day = date.getUTCDay();

    switch (day) {
      case 0:
        return "'prošle nedjelje u' p";

      case 3:
        return "'prošle srijede u' p";

      case 6:
        return "'prošle subote u' p";

      default:
        return "'prošli' EEEE 'u' p";
    }
  },
  yesterday: "'juče u' p",
  today: "'danas u' p",
  tomorrow: "'sutra u' p",
  nextWeek: function (date) {
    var day = date.getUTCDay();

    switch (day) {
      case 0:
        return "'sljedeće nedjelje u' p";

      case 3:
        return "'sljedeću srijedu u' p";

      case 6:
        return "'sljedeću subotu u' p";

      default:
        return "'sljedeći' EEEE 'u' p";
    }
  },
  other: 'P'
};

function formatRelative(token, date, _baseDate, _options) {
  var format = formatRelativeLocale[token];

  if (typeof format === 'function') {
    return format(date);
  }

  return format;
}

module.exports = exports.default;